
import cadquery as cq

# Define the base length and calculate a taller height to make the base angles closer to 90 degrees
base_length = 1.0
height = base_length * 2  # Increasing height to make base angles closer to 90 degrees

# Define the points of the isosceles triangle
points = [(0, 0), (base_length, 0), (0.5 * base_length, height)]

# Create the workplane, draw the triangle and extrude
result = cq.Workplane("XY").polyline(points).close().extrude(1.0)

# Export the refined result to STL
result.val().exportStl("Refine_2.stl")
