
import cadquery as cq

# Define the dimensions
rect_length = 10.0
rect_width = 9.0
trap_base = rect_width * 2 / 3
trap_height = trap_base / 10
extrude_amount = 0.5

# Create the rectangle
result = cq.Workplane("front").rect(rect_length, rect_width)

# Create the trapezium
result = result.moveTo(rect_length / 2 - trap_base / 2, rect_width / 2).polyline([
    (0, 0),
    (trap_base, 0),
    (trap_base + trap_height / 2, trap_height),
    (-trap_height / 2, trap_height),
    (0, 0)
])

# Extrude the sketch
result = result.extrude(extrude_amount)

# Export the result
result.val().exportStl("Generated.stl")
