
import cadquery as cq

# Define the dimensions of the pedestal
base_width, base_height = 10.0, 2.0
step_width, step_height = 6.0, 1.0  # assuming step should be less tall than base height for standard look

# Create the base of the pedestal
pedestal = cq.Workplane("front").rect(base_width, base_height).extrude(5.0)

# Move up to the top of the base and create the second step. 
# Slightly shift the step backward to center it more towards the back.
pedestal = pedestal.faces(">Z").workplane(centerOption="CenterOfBoundBox").rect(step_width, step_height).translate((2.0, 0, 0)).extrude(3.0)

# Save the output
pedestal.val().exportStl("Refine_2.stl")
