
import cadquery as cq

# Define dimensions
length = 80.0  # Length of the rectangle
width = 20.0  # Width of the rectangle
thickness = 10.0  # Thickness of the rectangle
square_length = length / 16  # 1/16 length of the rectangle
square_thickness = thickness / 3  # 1/3 thickness of the rectangle

# Create the rectangle
result = (
    cq.Workplane("XY")
    .rect(length, width)
    .extrude(thickness)
)

# Create the squares, centered aligning with shorter edges (width sides)
for x_offset in [length/2 - square_length/2, -(length/2 - square_length/2)]:
    result = (
        result
        .faces("<Z")  # Using bottom face to ensure correct orientation
        .workplane(centerOption="CenterOfBoundBox")
        .center(x_offset, 0)
        .rect(square_length, width)
        .extrude(square_thickness, combine=True)
    )

# Export the corrected result
result.val().exportStl("Refine_2.stl")
