
import cadquery as cq

# Define the dimensions for the rectangle and trapezoid
base_length = 2.0
rect_height = base_length / 2
trapezoid_base_long = base_length
trapezoid_base_short = 1.0
trapezoid_height = 0.5

# Create a rectangle
r = cq.Workplane("front").rect(base_length, rect_height)

# Positioning adjustment for the trapezoid to connect at one end of the rectangle
# and using the longer base of trapezoid along the length of rectangle
r = r.pushPoints([(-base_length / 2, 0)]).polyline([
    (base_length / 2, 0),  # starts from the left end of the rectangle's top side
    (trapezoid_base_long / 2, trapezoid_height),
    (trapezoid_base_short / 2, trapezoid_height),
    (trapezoid_base_short / 2, 0)  # ends on the trapezoid's short base
]).close()

# Extrude the corrected sketch to create a 3D object
result = r.extrude(1.0)

# Save the output as STL
result.val().exportStl("Refine_2.stl")
