
import cadquery as cq

# Define the parameters of the ring
outer_radius = 10.0
inner_radius = 5.0
extrude_length = 20.0

# Create the ring
result = (
    cq.Workplane("XZ")  # Z-axis is up, extrude along X-axis
    .circle(outer_radius)
    .circle(inner_radius)
    .extrude(extrude_length, combine=True)  # Ensure correct extrusion along X-axis
)

# Export the result
result.val().exportStl("Refine_1.stl")
