
import cadquery as cq

# Define the points for the irregular hexagon
# Original rectangle would be (0,0) to (10,5), cutting off corners at (2,5) and (8,5)
points = [(0, 0), (10, 0), (10, 2), (8, 5), (2, 5), (0, 2)]

# Create the workplane and draw the hexagon
r = cq.Workplane("front").polyline(points).close()

# Extrude the hexagon
result = r.extrude(0.5)

# Export the result
result.val().exportStl("Refine_1.stl")
