
import cadquery as cq
import math

# Define the number of points and the radius of the star
num_points = 5
outer_radius = 10.0
inner_radius = 5.0

# Create the initial workplane
result = cq.Workplane("XY")

# Positions for outer and inner vertices
outer_positions = [(outer_radius * math.cos(2 * math.pi * i / num_points),
                    outer_radius * math.sin(2 * math.pi * i / num_points)) for i in range(num_points)]

inner_positions = [(inner_radius * math.cos(2 * math.pi * (i + 0.5) / num_points),
                    inner_radius * math.sin(2 * math.pi * (i + 0.5) / num_points)) for i in range(num_points)]

# Move to the first outer position
result = result.moveTo(*outer_positions[0])

# Create the star by alternating between outer and inner positions
for i in range(num_points):
    next_outer = outer_positions[(i + 1) % num_points]
    next_inner = inner_positions[i]
    result = result.lineTo(*next_inner).lineTo(*next_outer)

# Close the shape and extrude it
result = result.close().extrude(5.0)

# Export the result
result.val().exportStl("Refine_1.stl")
