
import cadquery as cq

# Define the dimensions
rect_length = 10.0
rect_width = 5.0
trap_height = 5.0
trap_small_base = 5.0
trap_large_base = rect_length
extrude_amount = 20.0

# Define the positions
rect_x_center = 0
rect_y_center = trap_height + (rect_width / 2)

# Create a new workplane
result = cq.Workplane("front")

# Create the rectangle starting at the defined center
result = result.rect(rect_length, rect_width).translate((rect_x_center, rect_y_center))

# Create the trapezium directly below the rectangle
result = result.moveTo(rect_x_center, trap_height / 2).polyline([
    ((trap_small_base / 2), 0),
    ((trap_large_base / 2), trap_height),
    (-(trap_large_base / 2), trap_height),
    (-(trap_small_base / 2), 0)
]).close()

# Extrude the combined sketch
result = result.extrude(extrude_amount)

# Export the result
result.val().exportStl("Refine_1.stl")
