
import cadquery as cq

# Define the dimensions
rect_length = 10.0
rect_width = 5.0
trap_height = 5.0
trap_small_base = 5.0
trap_large_base = rect_length
extrude_amount = 20.0

# Create a new workplane
result = cq.Workplane("front")

# Start the sketch with the trapezium
result = result.polyline([
    (-(trap_large_base / 2), 0),
    (-(trap_small_base / 2), trap_height),
    ((trap_small_base / 2), trap_height),
    ((trap_large_base / 2), 0)
]).close()

# Translate up to attach it to the bottom of the rectangle
result = result.translate((0, trap_height / 2))

# Create the rectangle right on top of the trapezium to make them seamlessly connect
result = result.rect(rect_length, rect_width).translate((0, rect_width / 2 + trap_height))

# Extrude the combined sketch
result = result.extrude(extrude_amount)

# Export the result
result.val().exportStl("Refine_2.stl")
