
import cadquery as cq

# Create the base rectangle
base = cq.Workplane("XY").rect(3, 2).extrude(1)

# Create the cutout rectangle
cutout = cq.Workplane("XY").workplane(offset=1).rect(2, 1.33).extrude(-1)

# Combine the base and the cutout
result = base.cut(cutout)

# Export the result
result.val().exportStl("Generated.stl")
