
import cadquery as cq

# Constants for dimensions
length_base = 100
width_base = 50
thickness_base = 10

length_hole = length_base / 4  # 1/4 of the base length
width_hole = width_base / 4   # 1/4 of the base width
thickness_hole = thickness_base

# Create the base plate
base_plate = cq.Workplane("XY").box(length_base, width_base, thickness_base)

# Create the hole. Assume a slight space from the bottom.
hole = (
    cq.Workplane("XY")
    .workplane(offset=thickness_base)
    .rect(length_hole, width_hole)
    .extrude(-thickness_hole)
    .translate((0, (width_base - width_hole) / 2 - 5, 0))  # Translate to position hole nearer the bottom
)

# Combine the base and the hole
result = base_plate.cut(hole)

# Export the result
result.val().exportStl("Refine_1.stl")
