
import cadquery as cq

# Create the main body of the whistle
cylinder = cq.Workplane("XY").circle(10).extrude(5)

# Create the rectangular block, adjusted to extrude from the cylinder's curved surface
# It starts from the top center and moves outward with a focus on positioning more naturally on the curve
# Narrow and short as per specification, with adequate lengths to extend beyond the cylinder's side
block = cylinder.faces(">Z").workplane(invert=True)\
            .center(-11, 0)  # Center operation to shift the rectangle to start at an edge
            .rect(4, 1).extrude(2, combine=False)

# Combine the cylinder with the properly positioned and adjusted block
whistle = cylinder.union(block)

# Export the result with updated requirements
whistle.val().exportStl("Refine_2.stl")
