
import cadquery as cq

# Define dimensions
square_size = 10.0
extrusion_height = 5.0
inner_square_size = 8.0
inner_extrusion_height = 4.0
circle_diameter = 1.0
circle_extrusion_height = 4.5
small_circle_diameter = 0.5
small_circle_extrusion_height = 4.4  # Adjusted so that it is less than the square extrusion height
small_circle_offset = 2.0

# Create the outer square and extrude it
result = cq.Workplane("XY").box(square_size, square_size, extrusion_height)

# Hollow out the inside of the square
result = result.faces(">Z").workplane().rect(inner_square_size, inner_square_size).cutBlind(-inner_extrusion_height)

# Create the large circle at the bottom of the square
result = result.faces("<Z").workplane().circle(circle_diameter / 2).extrude(circle_extrusion_height)

# Create the four smaller circles at the corners of the square, ensuring proper integration on the top surface of the square
for x in [-1, 1]:
    for y in [-1, 1]:
        result = result.faces(">Z").workplane().center(x * small_circle_offset, y * small_circle_offset).circle(small_circle_diameter / 2).cutBlind(-small_circle_extrusion_height)

# Export the result
result.val().exportStl("Refine_1.stl")
