
import cadquery as cq

# Define the points the spline will pass through to closely form half a heart shape
points = [
    (0, 1),  # tip of the heart
    (-0.2, 1.2),
    (-0.5, 1.8),
    (-1.0, 1.8),
    (-0.7, 1.1),
    (-0.4, 0.5),
    (0.0, 0.0)  # bottom center of the heart
]

# Create a workplane that an object can be built on
# Use the named plane orientation "front" to define the workplane
# Draw the spline through the defined points
# Mirror the spline about the Y-axis (the correct axis for symmetry in this configuration)
# Extrude the heart shape to create a 3D object
result = (
    cq.Workplane("front")
    .moveTo(0, 0)  # start from the center bottom to make sure symmetry is correct
    .spline(points, includeCurrent=True)
    .mirrorY()
    .extrude(1)
)

# Export the result to STL with corrected name as specified
result.val().exportStl("Refine_1.stl")
