
import cadquery as cq

# Define the points the spline will pass through to closely form half a heart shape
# Adjusting the points to form a proper heart shape
points = [
    (-1.5, 2.5),  # Move this point further out for a wider upper part of the heart
    (-0.5, 3.5),  # Apex of upper heart curves
    (-0.5, 3.0),
    (0, 2.5),  # Central top tip of the heart
    (0.5, 3.0),
    (0.5, 3.5),  # Symmetric to the left for right upper curve
    (1.5, 2.5), 
    (1.0, 1.0),
    (0, 0)  # Bottom center of the heart
]

# Create a workplane that an object can be built on
# Use the named plane orientation "front" to define the workplane
result = (
    cq.Workplane("front")
    .moveTo(0, 0)  # start from the bottom center for symmetry
    .spline(points, includeCurrent=True)  # Use corrected and balanced points
    .close()  # Close the shape to form a proper heart
    .extrude(1)  # Extrude to make the shape 3D
)

# Export the result as an STL file
result.val().exportStl("Refine_2.stl")
