
import cadquery as cq

# Define the dimensions
base = 10.0  # Length of the base of the triangle
height = 22.0  # Height is more than twice the base
thickness = 0.5  # Thickness of the walls

# Create the sketch
result = (
    cq.Workplane("front")
    .moveTo(0, 0)  # Start from the origin
    .lineTo(base, 0)  # Line to the right-end of the base
    .lineTo(0, height)  # Line to the top of the triangle
    .close()  # Close the path to form the triangle
    .offset2D(-thickness)  # Create an inward offset for the hollow part
    .extrude(thickness)  # Extrude the shape to add depth
)

# Export the result in STL format
result.val().exportStl("Refine_1.stl")  # Correct the file name as per requirement
