
import cadquery as cq

# Create a sketch of a rectangle and extrude it
result = cq.Workplane("front").rect(10, 5).extrude(0.5)

# Define the dimensions of the cutout rectangles
cutout_width, cutout_height = 1, 1

# Cutout two small rectangles from the bottom left and bottom right corners
result = (result
          .faces("<Z").workplane(centerOption="CenterOfBoundBox")
          .rect(10, 5, forConstruction=True)
          .vertices("<Y and >X").rect(cutout_width, cutout_height).cutThruAll()     # Bottom right corner
          .vertices("<Y and <X").rect(cutout_width, cutout_height).cutThruAll())    # Bottom left corner

# Save the output
result.val().exportStl("Refine_2.stl")
