
import cadquery as cq

# Create the base rectangle
base = cq.Workplane("XY").rect(10, 5).extrude(2)

# Create the smaller rectangle on top of the base
top = cq.Workplane("XY").workplane(offset=2).rect(8, 4).extrude(2)

# Combine the two shapes
result = base.union(top)

# Export the result
result.val().exportStl("Generated.stl")
