
import cadquery as cq

# Create the base rectangle
base = cq.Workplane("XY").rect(10, 5).extrude(2)

# Adjust the creation of the smaller rectangle on top to have the same length but a smaller width
top = cq.Workplane("XY").workplane(offset=2).rect(10, 4).extrude(2)

# Combine the two shapes
result = base.union(top)

# Save the output with the corrected STL file name as mentioned
result.val().exportStl("Refine_2.stl")
