
import cadquery as cq

# Define the dimensions of the trapezoid
bottom_length = 10.0
top_length = 6.0
height = 8.0
thickness = 2.0

# Define the dimensions of the hole
hole_bottom_length = 8.0
hole_top_length = 4.0  # Making this a bit smaller to emphasize the hole
hole_height = 6.0

# Create the trapezoid
trapezoid = (
    cq.Workplane("front")
    .moveTo(-bottom_length / 2, 0)
    .lineTo(bottom_length / 2, 0)
    .lineTo(top_length / 2, height)
    .lineTo(-top_length / 2, height)
    .close()
    .extrude(thickness)
)

# Create the hole, centered and smaller
hole = (
    cq.Workplane("front")
    .center(0, (height - hole_height) / 2)
    .moveTo(-hole_bottom_length / 2, 0)
    .lineTo(hole_bottom_length / 2, 0)
    .lineTo(hole_top_length / 2, hole_height)
    .lineTo(-hole_top_length / 2, hole_height)
    .close()
    .extrude(thickness, both=True)  # Ensuring the hole goes through both sides
)

# Subtract the hole from the trapezoid, ensuring it cuts through
result = trapezoid.cut(hole)

# Export the result
result.val().exportStl("Refine_2.stl")
