
import cadquery as cq

# Create a rectangle
rectangle = cq.Workplane("XY").rect(10, 2).extrude(0.5)

# Create two cylinders on one end of the rectangle
cylinder1 = cq.Workplane("XY").workplane(offset=0.5).center(-4, 0).circle(0.5).extrude(0.5)
cylinder2 = cq.Workplane("XY").workplane(offset=0.5).center(-6, 0).circle(0.5).extrude(0.5)

# Combine the rectangle and the cylinders
result = rectangle.union(cylinder1).union(cylinder2)

# Export the result
result.val().exportStl("Generated.stl")
