
import cadquery as cq

# Create a rectangle
rectangle = cq.Workplane("XY").rect(10, 2).extrude(0.5)

# Create two cylinders on one end of the rectangle, at the correct location
cylinder1 = rectangle.faces("<Y").workplane(centerOption="CenterOfBoundBox").center(-4.5, 1).circle(0.5).extrude(0.5)
cylinder2 = rectangle.faces("<Y").workplane(centerOption="CenterOfBoundBox").center(-4.5, -1).circle(0.5).extrude(0.5)

# Combine the rectangle and the cylinders
result = rectangle.union(cylinder1).union(cylinder2)

# Export the result
result.val().exportStl("Refine_2.stl")
