
import cadquery as cq
import math

# Parameters for the pipe
outer_radius = 10.0
inner_radius = 8.0
height = 20.0
angle = 60.0  # Angle to cut out from the pipe

# Create the outer cylinder
outer_cylinder = cq.Workplane("XY").cylinder(height, outer_radius)

# Create the inner cylinder
inner_cylinder = cq.Workplane("XY").cylinder(height, inner_radius)

# Create the hollow cylinder by subtracting the inner cylinder from the outer cylinder
pipe = outer_cylinder.cut(inner_cylinder)

# Calculate the angle for proper subtraction
angle_radians = math.radians(angle)

# Create a wedge to subtract
wedge = (pipe.faces(">Z").workplane()
         .moveTo(outer_radius, 0)
         .polyline([(outer_radius * math.cos(angle_radians), outer_radius * math.sin(angle_radians)), (0, 0)])
         .close().revolve(angle, (0, 0, 1), (1, 0, 1)))

# Subtract the wedge from the pipe to create an open section
pipe_without_section = pipe.cut(wedge)

# Export the resulted model with the refined name
cq.exporters.export(pipe_without_section, 'Refine_2.stl')
