
import cadquery as cq
import math

# Define the curve and dimensions
vertical_height = 10
horizontal_length = 5
thickness = 2
curve_radius = 1
extrude_depth = 1

# Create the sketch with a curve for the vertical section
result = (
    cq.Workplane("front")
    .vLine(vertical_height - curve_radius)  # Vertical line up
    .threePointArc((curve_radius, vertical_height), (curve_radius * 2, vertical_height - curve_radius))  # Curved top
    .hLineTo(horizontal_length)  # Horizontal line right
    .vLineTo(curve_radius)  # Vertical line down
    .threePointArc((horizontal_length - curve_radius, 0), (horizontal_length - curve_radius * 2, curve_radius))  # Curved bottom
    .close()  # Close the sketch
    .extrude(extrude_depth)  # Extrude the shape
)

# Preview the object (Use a viewer to see progress)
# show_object(result) 

# Export the result
result.val().exportStl("Refine_1.stl")
