
import cadquery as cq

# Create the base cylinder (large cylinder)
result = cq.Workplane("XY").circle(10.0).extrude(20.0)

# Create the smaller cylinder on top of the base cylinder
result = result.faces(">Z").workplane().circle(5.0).extrude(10.0, combine=True)

# Export the result to an STL file with a new file name as per the newer requirement
result.val().exportStl("Refine_2.stl")
