
import cadquery as cq

# Create a sketch with two overlapping circles by translating the second circle
result = cq.Workplane("XY").circle(10.0).moveTo(5,0).circle(10.0).extrude(1)

# Cutout two smaller overlapping circles
cutout = cq.Workplane("XY").moveTo(5,0).circle(5.0).moveTo(10,0).circle(5.0).extrude(1)

# Cut the overlapping smaller circles from the original shape
result = result.cut(cutout)

# Export the result
result_val = result.val()  # Capture the final solid for verification
result_val.exportStl("Refine_1.stl")
