
import cadquery as cq

# Dimensions for the main plate
plate_height = 60.0
plate_width = plate_height * (2/3)
plate_thickness = 10.0

# Dimensions for the slot
slot_width = 5.0
slot_length = plate_thickness  # Matching the thickness of the plate

# Create the main plate
plate = cq.Workplane("front").box(plate_width, plate_thickness, plate_height)

# Create the slot
# The slot should be a through slot and match the center of the plate along its height
slot = (
    plate.faces(">Z")  # Start from the top face of the plate
    .workplane(centerOption="CenterOfBoundBox")  # Center workplane on the top face of the plate
    .rect(slot_width, slot_length)
    .extrude(-plate_height, combine=True)  # Correct this extrusion to move across the entire height
)

# Subtract the slot from the plate
result = plate.cut(slot)

# Export the result
result.val().exportStl("Refine_2.stl")
