
import cadquery as cq

# Parameters for the main square and the small rectangles
main_square_side = 10.0
rectangle_width = 1.0
rectangle_height = 2.0
extrude_depth = 0.5

# Create the main square
result = cq.Workplane("front").rect(main_square_side, main_square_side)

# Create the small rectangles on the left and right edges of the square
result = result.rect(rectangle_width, rectangle_height).translate((-main_square_side/2, 0))
result = result.rect(rectangle_width, rectangle_height).translate((main_square_side, 0))

# Extrude the sketch to get the final object
result = result.extrude(extrude_depth)

# Save the output
result.val().exportStl("Generated.stl")
