
import cadquery as cq

# Define the 3D extrusion height
height = 5

# Create the workplane and the base rectangle
workplane = cq.Workplane("XY")
base = workplane.rect(10, 20)

# Create and merge the smaller rectangles correctly positioned to ensure proper puzzle piece-like extensions
small_rect1 = workplane.rect(5, 10).translate((7.5, -10))  # Adjust coordinates to align correctly
small_rect2 = workplane.rect(5, 10).translate((-7.5, -10)) # Adjust coordinates to align correctly

# Combine all shapes and extrude
result = (base.add(small_rect1).add(small_rect2)).extrude(height)

# Create the large circular hole
result = result.faces(">Z").workplane().hole(10)  # Adjust the diameter as per the appropriate size

# Export the result
result.val().exportStl("Refine_1.stl")
