
import cadquery as cq

# Parameters for the wrench
length = 100.0  # Length of the wrench
width = 10.0  # Width of the wrench
thickness = 5.0  # Thickness of the wrench
small_radius = 15.0  # Radius of the small circle
large_radius = 20.0  # Radius of the large circle
small_hole_radius = 7.0  # Radius of the small hole
large_hole_radius = 10.0  # Radius of the large hole

# Create the base rectangle
result = cq.Workplane("XY").rect(length, width)

# Add the circles at the ends
result = result.moveTo(-length / 2, 0).circle(large_radius)
result = result.moveTo(length, 0).circle(small_radius)

# Extrude the sketch
result = result.extrude(thickness)

# Create the holes
result = result.faces(">Z").workplane().center(-length / 2, 0).hole(large_hole_radius * 2)
result = result.faces(">Z").workplane().center(length / 2, 0).hole(small_hole_radius * 2)

# Export the result
result.val().exportStl("Generated.stl")
