
import cadquery as cq

# Parameters for the wrench
length = 110.0  # Length of the wrench
width = 10.0  # Width of the wrench
thickness = 5.0  # Thickness of the wrench
small_radius = 12.0  # Radius of the small circular end of the wrench
large_radius = 17.0  # Radius of the large circular end of the wrench
small_hole_radius = 4.0  # Radius of the hole in small circular end
large_hole_radius = 6.0  # Radius of the hole in large circular end

# Create the main body of the wrench
result = (cq.Workplane("XY")
            .moveTo(-length/2, -width/2)
            .hLineTo(-length/2 + large_radius)  # line to start of large radius
            .threePointArc((0, large_radius-width/2), (length/2 - small_radius, -width/2))  # large arc
            .hLineTo(length/2)  # horizontal line to start of small radius
            .threePointArc((length/2 + small_radius, width/2), (length/2 - small_radius, width/2))  # small arc
            .hLineTo(-length/2 + large_radius)  # return back drawing horizontal
            .threePointArc((0, -large_radius+width/2), (-length/2, width/2))  # closing large arc
            .close()  # Close the sketch to form a proper loop
            .extrude(thickness))

# Create holes in the circular ends of the wrench
result = result.faces(">Z").workplane(centerOption="CenterOfBoundBox")
result = result.pushPoints([(-length/2, 0), (length/2, 0)])  # Positions for the holes
result = result.hole(2 * large_hole_radius)  # Hole in the large end
result = result.hole(2 * small_hole_radius)  # Hole in the small end

# Export the model
result.val().exportStl("Refine_1.stl")
