
import cadquery as cq

# Create a cylinder
cylinder = cq.Workplane("XY").circle(10).extrude(20)

# Create an octagonal hole within the cylinder
result = cylinder.faces(">Z").workplane().polygon(8, 5).cutThruAll()

# Save the output
result.val().exportStl("Generated.stl")
