
import cadquery as cq

# Create a cylinder
cylinder = cq.Workplane("XY").circle(10).extrude(20)

# Ensure the hole cuts through all - checking the operation to explicitly cut through the entire length
result = cylinder.faces(">Z").workplane().polygon(8, 5).cutThruAll()

# Save the output with the corrected file name as prompted
result.val().exportStl("Refine_1.stl")
