
import cadquery as cq

# Parameters
length = 10.0  # Length of the rectangle
width = 5.0    # Width of the rectangle
triangle_height = 3.0  # Height of the isoselces triangle
extrusion_height = 1.0  # Height to extrude the sketch
cutout_depth = 1.0     # Depth of the triangular cutouts at the bottom corners

# Create a new sketch
sketch = cq.Sketch()

# Draw the main rectangle
sketch.rect(length, width)

# Draw the isosceles triangle on top of the rectangle
triangle = cq.Sketch().polygon(3, length)
triangle = triangle.translate((length / 2, width / 2))
sketch.union(triangle)

# Adding cutouts at the bottom corners of the rectangle
cutout_triangle = cq.Sketch().polygon(3, cutout_depth).mirror("X")
cutout_triangle_1 = cutout_triangle.translate((cutout_depth / 2, -cutout_depth / 2))
cutout_triangle_2 = cutout_triangle.translate((length - cutout_depth / 2, -cutout_depth / 2))
sketch = sketch.subtract(cutout_triangle_1).subtract(cutout_triangle_2)

# Extrude the sketch to create a 3D object
result = sketch.extrude(extrusion_height)

# Export the result as an STL file
result.val().exportStl("Refine_2.stl")
