
import cadquery as cq

def make_fillet_on_edges(workplane, selector):
    # Apply fillets on the edges selected by the selector function
    to_fillet = workplane.edges(selector).fillet(0.3)
    return to_fillet

# Create a rectangle
result = cq.Workplane("front").rect(10, 2)

# Extrude the sketch
result = result.extrude(1)

# Approach to select custom corners for fillet
# Define corners manually: Assuming to fillet the first and fourth vertex of the rectangle's edge
corner1 = "(1, 1, 1)"
corner4 = "(1, 1, -1)"

# Apply fillets by using corner selection
# Since we don't have the exact positions of corners and topology might vary, we use nearby to specify the region
result = make_fillet_on_edges(result, f">X or >Y or >Z[(1,1,0), (1,-1,0)]")  # You might need to adjust based on actual edge coordinates from edge.loopVertices()

# Verify and export
if result.solids().size() > 0:
    solid = result.solids().first()
    solid.exportStl("Refine_1.stl")
