
import cadquery as cq
import math

# Create a regular hexagon
hexagon = cq.Workplane("XY").polygon(6, 20).extrude(10)  # Hexagon with side length of 20 and height 10

# Create a smaller square on top of the hexagon
square = (cq.Workplane("XY")
          .workplane(offset=10)  # This sets the square directly on top of the hexagon
          .transformed(rotate=(0, 0, 30))  # Rotate 30 degrees, slightly less to prevent alignment with hexagon vertices
          .rect(15, 15)  # Slightly reduced size to prevent overlapping the hexagon
          .extrude(10))  # Same extrusion height

# Combine the hexagon and the square
result = hexagon.union(square)

# Export the result with updated filename as requested
result.val().exportStl("Refine_2.stl")
