
import cadquery as cq

# Define the dimensions
block_width = 20.0
block_height = 10.0
block_depth = block_height / 4
hole_width = block_width * 5 / 12
hole_height = block height * 7 / 10
hole_depth = block_depth
hole_radius = 1.0  # Radius for the rounded corners

# Create the block
block = cq.Workplane("front").box(block_width, block_height, block_depth)

# Create the holes with rounded corners
holes = (
    cq.Workplane("front")
    .rect(hole_width, hole_height)
    .extrude(-hole_depth)
    .edges("|Z")  # Select vertical edges of the hole for filleting
    .fillet(hole_radius)
)

# Position the holes symmetrically about the vertical centerline
hole_offset = block_width / 4
result = block.cut(holes.translate((hole_offset, 0, block_depth/2)))
result = result.cut(holes.translate((-hole_offset, 0, block_depth/2)))

# Save the output
result.val().exportStl("Refined_1.stl")
