
import cadquery as cq

# Create a rectangular plate
plate = cq.Workplane("XY").box(80, 20, 5)

# Function to create a square cutout with rounded edges at two corners
def make_cutout(workplane, x_position):
    # Adjusting the function to ensure the cutout is correctly positioned and extruded
    return (workplace
            .workplane(centerOption="CenterOfBoundBox")  # Operating correct context
            .pushPoints([(x_position, -5), (x_position, 5)])  # Specifying position for the square centers
            .rect(10, 10, forConstruction=False)
            .vertices(">X or <X")  # Select vertices on the longer edge
            .fillet(2)  # Applying a smaller fillet that does not vanish
            .cutThrough())  # Cutting through the entire thickness

# Apply cutouts to the plate, considering the correct positioning
result = make_cutout(plate, 5)     # First cutout at the beginning corner
result = make_cutout(result, 75)   # Second cutout at the opposite end corner

# Export the result as 'Refine_2.stl'
result.val().exportStl("Refine_2.stl")
