
import cadquery as cq

# Define the dimensions
base_small = 10.0  # Small base of the trapezium
base_large = 20.0  # Large base of the trapezium
height = 15.0      # Height of the trapezium
extrude_amount = 100.0  # Amount to extrude the trapezium

# Calculate the overhang on each side for an isosceles trapezium
overhang = (base_large - base_small) / 2

# Create an isosceles trapezium sketch, making sure the small base is centered
centered_small_base_start = -base_small / 2
centered_small_base_end = base_small / 2
centered_large_base_start = -base_large / 2
centered_large_base_end = base_large / 2

r = (cq.Workplane("front")
     .moveTo(centered_small_base_start, 0)
     .lineTo(centered_small_base_end, 0)
     .lineTo(centered_large_base_end, height)
     .lineTo(centered_large_base_start, height)
     .close())

# Extrude the sketch to create the prism
result = r.extrude(extrude_amount)

# Export the result with the correct file name as mentioned
result.val().exportStl("Refine_2.stl")
