
import cadquery as cq

# Parameters
desk_length = 100.0
desk_width = 60.0
desk_thickness = 2.0
leg_length = 50.0
hexagon_size = 15.0
cutout_size = 5.0

# Sketching the inverted desk based on the target description
desk = (
    cq.Workplane("XY")
    # Create the base rectangle
    .rect(desk_length, desk_width)
    # Remove cutout from each corner to form an octagonal surface
    .vertices().chamfer(cutout_size)
    # Extrude the desk plate
    .extrude(desk_thickness)
)

# Creating two symmetric hexagonal columns
leg = (
    cq.Workplane("XY")
    .polygon(6, hexagon_size)
    .extrude(leg_length)
)

# Positioning the legs at the two ends of the octagonal surface
legs_positioning = desk_length/2 - hexagon_size
desk = (
    desk
    .faces(">Z")  # Work on the top face of the desk surface
    .workplane(centerOption="CenterOfBoundBox")
    # Adding two legs positioned symmetrically from the center on the long side
    .pushPoints([(-legs_positioning, 0), (legs_positioning, 0)])
    .eachpoint(lambda loc: leg.moved(loc))
)

# Export the model into an STL file
desk.val().exportStl("Refine_1.stl")
