
import cadquery as cq

# Parameters
desk_length = 100.0
desk_width = 60.0
desk_thickness = 2.0
leg_length = 50.0
hexagon_size = 15.0
cutout_size = 5.0

# Create the base sketch for the desk
desk = (
    cq.Workplane("XY")
    # Create rectangle
    .rect(desk_length, desk_width)
    # Cut out small right-angle triangles from each corner
    .vertices().chamfer(cutout_size)
    # Extrude the octagonal desk surface
    .extrude(desk_thickness)
)

# Define the shape for the hexagonal legs
legs = (
    cq.Workplane("XY")
    .polygon(6, hexagon_size)
    .extrude(leg_length)
)

# Calculate the correction needed for the position of the legs, on the short side and aligned with the octagonal ends
# Octagonal endpoints calculate by approximation from rectangle dimensions minus triangles
legs_positioning = desk_width / 2 - hexagon_size / 2  # Updated position calculation

# Position the legs symmetrically on opposite ends of the octagonal desk surface
desk = (
    desk
    .faces(">Z")
    .workplane(centerOption="CenterOfBoundBox")
    # Replace (-legs_positioning, 0) with (0, lengths) to orient legs along the shorter width
    .pushPoints([(0, -legs_positioning), (0, legs_positioning)])   # Changed positioning points
    .eachpoint(lambda loc: legs.moved(loc), True)
)

# Export the model into an STL file with updated name as requested
desk.val().exportStl("Refine_2.stl")
