
import cadquery as cq

# Define the dimensions
length = 10.0
width1 = 5.0  # Width of the base rectangle
width2 = 3.0  # Width of the upper rectangle
height = 2.0  # Height of each extrusion
hole_diameter = 1.0

# Create the base rectangle
result = cq.Workplane("XY").rect(length, width1).extrude(height)

# Create the smaller rectangle on top, ensure it is at the end of the larger rectangle, align x, same z.
result = result.faces(">Z").workplane().rect(length, width2).translate((length/2 - width2/2, 0, 0)).extrude(height)

# Create the hole through the center of the upper rectangular block
result = result.faces(">Z").workplane().center(0, 0).circle(hole_diameter / 2).cutThruAll()

# Export the result
result.val().exportStl("Refine_1.stl")
