
import cadquery as cq
import math

# Define the dimensions
base_length = 10.0  # Length of the base
top_length = 5.0  # Length of the top
height = 7.0  # Height of the trapezoid
extrude_amount = 2.0  # Amount to extrude the sketch
base_angle_deg = 70  # Base angle in degrees

# Calculate the necessary dimensions
base_angle_rad = math.radians(base_angle_deg)  # Convert base angle to radians
leg_length = height / math.tan(base_angle_rad / 2)  # Calculate the leg length

# End coordinates for top and bottom
bottom_left_x = -base_length / 2
bottom_right_x = base_length / 2
top_left_x = bottom_left_x + leg_length * math.sin(base_angle_rad)
top_right_x = bottom_right_x - leg_length * math.sin(base_angle_rad)

result = (cq.Workplane("front")
          .moveTo(bottom_left_x, 0)
          .lineTo(top_left_x, height)
          .lineTo(top_right_x, height)
          .lineTo(bottom_right_x, 0)
          .close()
          .extrude(extrude_amount))

# Export the result
result.val().exportStl("Refine_2.stl")
