
import cadquery as cq

# Create the sketch of the irregular rhombus and close it
rhombus = cq.Workplane("front").polyline([(0, 0), (2, 4), (4, 0), (2, -4)]).close()

# Extrude the rhombus
rhombus = rhombus.extrude(1)

# Create the sketch of the rectangular prism with revised dimensions to better suit the design
rect_prism = cq.Workplane("front").box(4, 1, 1.5).translate((2, 0, 0.5))

# Translate the rectangular prism to attach it correctly to the edge
# Calculate proper translations to move prism to the center of the rhombus and bring it up to the edge
rect_prism = rect_prism.translate((0, 0, 0.5))

# Combine the two shapes
result = rhombus.union(rect_prism)

# Export the result with the updated file name
result.val().exportStl("Refine_1.stl")
