
import cadquery as cq

# Updated larger diameter based on feedback
diameter = 200.0  # Diameter made significantly larger than height
height = 50.0
cutout_diameter = 20.0

# Create main cylinder with larger diameter
result = cq.Workplane("XY").circle(diameter / 2.0).extrude(height)

# Create a central circular cutout through the entire height of the cylinder
result = result.faces(">Z").workplane().circle(cutout_diameter / 2.0).cutThruAll()

# Export the updated model to an STL file
result.val().exportStl("Refine_V_2.stl")
