
import cadquery as cq

# Table dimensions
table_length = 100.0
table_width = 60.0
table_thickness = 2.0

# Leg dimensions
leg_length = 1.0
leg_width = 1.0
leg_height = 70.0

# Create the table top
table_top = cq.Workplane("XY").box(table_length, table_width, table_thickness)

# Function to create a leg and position it appropriately
def create_leg(x_offset, y_offset):
    return (
        cq.Workplane("XY")
        .box(leg_length, leg_width, leg_height)
        .translate((x_offset, y_offset, -leg_height / 2 - table_thickness / 2))
    )

# Adjusting leg positions to align with the corners of the table top
legs = (
    create_leg(-table_length / 2 + leg_length / 2, -table_width / 2 + leg_width / 2).union(
    create_leg(table_length / 2 - leg_length / 2, -table_width / 2 + leg_width / 2)).union(
    create_leg(-table_length / 2 + leg_length / 2, table_width / 2 - leg_width / 2)).union(
    create_leg(table_length / 2 - leg_length / 2, table_width / 2 - leg_width / 2))
)

# Combine the table top and the legs
table = table_top.union(legs)

# Export the final model to an STL file
table.val().exportStl("Refine_V_1.stl")
