
import cadquery as cq

# Dimensions for the main rectangle
main_length = 10.0
main_width = 5.0
main_height = 0.5

# Dimensions for the cut-out
cutout_length = 4.0
cutout_width = 2.0
cutout_height = 0.5

# Creating the main rectangular block
result = cq.Workplane("XY").box(main_length, main_width, main_height)

# Positioning and creating the rectangular cut-out
# Centering the cut-out in the middle along the length (main_length/2 - cutout_length/2)
# Slightly above the midpoint of its height by adjusting the Y offset (main_width/2 - cutout_width/2 - 0.1)
result = result.faces(">Z").workplane()\
    .center(0, -0.1) \
    .rect(cutout_length,cutout_width)\
    .cutThruAll()

# Output the final model to an STL file
result.val().exportStl("Refine_V_1.stl")
