
import cadquery as cq

# Define the dimensions of the rectangle
length = 100.0  # Length of the rectangle in mm
width = 50.0    # Width of the rectangle in mm
thickness = 1.0  # Thickness of the extrusion in mm

# Create a CADQuery Workplane to build the geometry
result = (
    cq.Workplane("XY")
    .rect(length, width)  # Draw a rectangle with the specified dimensions
    .extrude(thickness)   # Extrude the rectangle to the specified thickness
)

# Output the result to an STL file with more descriptive variable naming
result.val().exportStl("Refine_V_2.stl")
