
import cadquery as cq

length = 100.0
width = 50.0
thickness = 10.0
hole_dia = 5.0
hole_offset = 10.0

result = cq.Workplane("XY").box(length, width, thickness)

# Positions for the four holes
positions = [
    (-length / 2 + hole_offset, -width / 2 + hole_offset),
    (length / 2 - hole_offset, -width / 2 + hole_offset),
    (length / 2 - hole_offset, width / 2 - hole_offset),
    (-length / 2 + hole_offset, width / 2 - hole_offset)
]

for position in positions:
    result = result.faces(">Z").workplane().center(*position).hole(hole_dia)

# Save the resultant object as an STL file
result.val().exportStl("Refine_V_2.stl")
